/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.lib39.core.api;

import com.google.common.collect.Lists;
import com.unascribed.lib39.core.Lib39Log;
import com.unascribed.lib39.core.api.RunType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class AutoMixin
implements IMixinConfigPlugin {
    private String pkg;
    private String binaryPkgPrefix;

    public void onLoad(String pkg) {
        Lib39Log.debug("AutoMixin loaded for {}", (Object)pkg);
        this.pkg = pkg;
        this.binaryPkgPrefix = pkg.replace('.', '/') + "/";
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    protected boolean getConfigValue(String key) {
        throw new AbstractMethodError("ifConfigSet or unlessConfigSet was used, but " + this.getClass().getName() + " does not override getConfigValue!");
    }

    protected boolean shouldAnnotationSkipMixin(String name, AnnotationNode an) {
        Map<String, Object> decoded;
        if (an.desc.equals("Lnet/fabricmc/api/Environment;") && (decoded = AutoMixin.decodeAnnotationParams(an)).get("value") != FabricLoader.getInstance().getEnvironmentType()) {
            Lib39Log.debug("Skipping @Environment({}) mixin {}", decoded.get("value"), (Object)name);
            return true;
        }
        if (an.desc.equals("Lorg/quiltmc/loader/api/minecraft/ClientOnly;") && FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            Lib39Log.debug("Skipping @ClientOnly mixin {}", (Object)name);
            return true;
        }
        if (an.desc.equals("Lorg/quiltmc/loader/api/minecraft/DedicatedServerOnly;") && FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER) {
            Lib39Log.debug("Skipping @DedicatedServerOnly mixin {}", (Object)name);
            return true;
        }
        if (an.desc.equals("Lcom/unascribed/lib39/core/mixinsupport/AutoMixinEligible;")) {
            decoded = AutoMixin.decodeAnnotationParams(an);
            if (AutoMixin.checkIfList(decoded.get("ifModPresent"), arg_0 -> ((FabricLoader)FabricLoader.getInstance()).isModLoaded(arg_0), "Skipping mixin " + name + " as required mod {} is not loaded")) {
                return true;
            }
            if (AutoMixin.checkUnlessList(decoded.get("unlessModPresent"), arg_0 -> ((FabricLoader)FabricLoader.getInstance()).isModLoaded(arg_0), "Skipping mixin " + name + " as incompatible mod {} is loaded")) {
                return true;
            }
            if (AutoMixin.checkIfList(decoded.get("ifSystemProperty"), Boolean::getBoolean, "Skipping mixin " + name + " as system property {} is unset or false")) {
                return true;
            }
            if (AutoMixin.checkUnlessList(decoded.get("unlessSystemProperty"), Boolean::getBoolean, "Skipping mixin " + name + " as system property {} is true")) {
                return true;
            }
            if (AutoMixin.checkIfList(decoded.get("ifConfigSet"), this::getConfigValue, "Skipping mixin " + name + " as config option {} is false")) {
                return true;
            }
            if (AutoMixin.checkUnlessList(decoded.get("unlessConfigSet"), this::getConfigValue, "Skipping mixin " + name + " as config option {} is true")) {
                return true;
            }
            if (decoded.containsKey("inEnvType") && decoded.get("inEnvType") != FabricLoader.getInstance().getEnvironmentType()) {
                Lib39Log.debug("Skipping {} mixin {}", decoded.get("inEnvType"), (Object)name);
                return true;
            }
            if (decoded.containsKey("inRunType") && decoded.get("inRunType") != RunType.getCurrent()) {
                Lib39Log.debug("Skipping {} mixin {}", decoded.get("inRunType"), (Object)name);
                return true;
            }
        }
        return false;
    }

    protected boolean shouldMixinBeSkipped(String name, ClassNode node) {
        if (this.checkAnnotations(name, node.invisibleAnnotations)) {
            return true;
        }
        return this.checkAnnotations(name, node.visibleAnnotations);
    }

    private boolean checkAnnotations(String name, List<AnnotationNode> annotations) {
        if (annotations != null) {
            for (AnnotationNode an : annotations) {
                if (!this.shouldAnnotationSkipMixin(name, an)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean checkIfList(Object list, Predicate<String> checker, String template) {
        return AutoMixin._checkList(true, list, checker, template);
    }

    protected static boolean checkUnlessList(Object list, Predicate<String> checker, String template) {
        return AutoMixin._checkList(false, list, checker, template);
    }

    private static boolean _checkList(boolean expect, Object list, Predicate<String> checker, String template) {
        if (list instanceof List) {
            List li = (List)list;
            for (Object str : li) {
                if (checker.test(String.valueOf(str)) == expect) continue;
                Lib39Log.debug(template, str);
                return true;
            }
        }
        return false;
    }

    protected static Map<String, Object> decodeAnnotationParams(AnnotationNode an) {
        HashMap<String, Object> out = new HashMap<String, Object>();
        for (int i = 0; i < an.values.size(); i += 2) {
            String k = (String)an.values.get(i);
            Object v = AutoMixin.decodeAnnotationValue(an.values.get(i + 1));
            if (v == null) continue;
            out.put(k, v);
        }
        return out;
    }

    protected static Object decodeAnnotationValue(Object v) {
        if (v instanceof String[]) {
            String[] arr = (String[])v;
            v = null;
            try {
                Class<?> clazz;
                String type = arr[0];
                if (type.startsWith("L") && type.endsWith(";") && Enum.class.isAssignableFrom(clazz = Class.forName(arr[0].substring(1, arr[0].length() - 1).replace('/', '.')))) {
                    v = Enum.valueOf(clazz, arr[1]);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return v;
        }
        if (v instanceof List) {
            List l = (List)v;
            return l.stream().map(AutoMixin::decodeAnnotationValue).toList();
        }
        if (v instanceof AnnotationNode) {
            AnnotationNode an = (AnnotationNode)v;
            return AutoMixin.decodeAnnotationParams(an);
        }
        return v;
    }

    public List<String> getMixins() {
        int skipped;
        int total;
        ArrayList rtrn;
        block34: {
            rtrn = Lists.newArrayList();
            total = 0;
            skipped = 0;
            try {
                URL url = AutoMixin.getJarURL(this.getClass().getProtectionDomain().getCodeSource().getLocation());
                Lib39Log.debug("Jar URL appears to be {}", (Object)url);
                if ("file".equals(url.getProtocol())) {
                    File f = new File(url.toURI());
                    if (f.isDirectory()) {
                        Path base = f.toPath();
                        try (Stream<Path> stream = Files.walk(base, new FileVisitOption[0]);){
                            Lib39Log.debug("Discovering mixins via directory iteration (Quilt/Fabric dev environment)");
                            for (Path p : stream::iterator) {
                                ++total;
                                if (!this.discover(rtrn, base.relativize(p).toString(), () -> Files.newInputStream(p, new OpenOption[0]))) continue;
                                ++skipped;
                            }
                            break block34;
                        }
                    }
                    try (ZipFile zip = new ZipFile(f);){
                        Lib39Log.debug("Discovering mixins via direct ZIP iteration (Fabric or old Quilt)");
                        for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                            ++total;
                            if (!this.discover(rtrn, zipEntry.getName(), () -> zip.getInputStream(en))) continue;
                            ++skipped;
                        }
                        break block34;
                    }
                }
                try (ZipInputStream zip22 = new ZipInputStream(url.openStream());){
                    ZipEntry en;
                    while ((en = zip22.getNextEntry()) != null) {
                        if (total == 0) {
                            Lib39Log.debug("Discovering mixins via URL ZIP iteration (Quilt <= 0.17)");
                        }
                        ++total;
                        if (!this.discover(rtrn, en.getName(), () -> zip22)) continue;
                        ++skipped;
                    }
                }
                catch (Exception zip22) {
                    // empty catch block
                }
                if (total != 0) break block34;
                Path base = null;
                try {
                    Optional modC = MethodHandles.publicLookup().findVirtual(FabricLoader.class, "quilt_getModContainer", MethodType.methodType(Optional.class, Class.class)).invoke(FabricLoader.getInstance(), this.getClass());
                    if (modC.isPresent()) {
                        Path baseTmp;
                        Lib39Log.debug("Discovering mixins via Quilt API (Quilt >= 0.18.1-beta.18)");
                        base = baseTmp = ((ModContainer)modC.get()).getRootPath();
                    }
                }
                catch (NoSuchMethodException nsme) {
                    Class<?> qmfsp = Class.forName("org.quiltmc.loader.impl.filesystem.QuiltMemoryFileSystemProvider");
                    MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(qmfsp, MethodHandles.lookup());
                    FileSystemProvider fsp = lookup.findStatic(qmfsp, "instance", MethodType.methodType(qmfsp)).invoke();
                    Lib39Log.debug("Discovering mixins via Quilt internals (Quilt 0.18.1-beta)");
                    base = fsp.getPath(url.toURI());
                }
                if (base != null) {
                    ++total;
                    for (Path p : Files.walk(base, new FileVisitOption[0])::iterator) {
                        ++total;
                        if (!this.discover(rtrn, base.relativize(p).toString(), () -> Files.newInputStream(p, new OpenOption[0]))) continue;
                        ++skipped;
                    }
                }
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot autodiscover mixins for " + this.pkg, e);
            }
        }
        if (rtrn.isEmpty()) {
            Lib39Log.warn("Found no mixins in {}", (Object)this.pkg);
        } else {
            Lib39Log.debug("Discovered {} mixins in {} (skipped {}, found {} total files)", rtrn.size(), this.pkg, skipped, total);
        }
        return rtrn;
    }

    private boolean discover(List<String> li, String path, StreamOpener opener) throws IOException {
        if ((path = path.replace('\\', '/')).endsWith(".class") && path.startsWith(this.binaryPkgPrefix)) {
            String name = path.replace('/', '.').replace(".class", "");
            if (name.contains("$")) {
                return false;
            }
            try {
                ClassReader cr = new ClassReader(opener.openStream());
                ClassNode cn = new ClassNode();
                cr.accept((ClassVisitor)cn, 7);
                if (this.shouldMixinBeSkipped(name, cn)) {
                    return true;
                }
                li.add(name.substring(this.binaryPkgPrefix.length()));
            }
            catch (IOException e) {
                Lib39Log.warn("Exception while trying to read {}", (Object)name, (Object)e);
            }
        }
        return false;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static URL getJarURL(URL codeSource) {
        if ("jar".equals(codeSource.getProtocol())) {
            String str = codeSource.toString().substring(4);
            int bang = str.indexOf(33);
            if (bang != -1) {
                str = str.substring(0, bang);
            }
            try {
                return new URL(str);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if ("union".equals(codeSource.getProtocol())) {
            String str = codeSource.toString().substring(6);
            int bullshit = str.indexOf("%23");
            if (bullshit != -1) {
                str = str.substring(0, bullshit);
            }
            try {
                return new URL("file:" + str);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return codeSource;
    }

    private static interface StreamOpener {
        public InputStream openStream() throws IOException;
    }
}

